class MH2_Weapon_Lawgiver extends enforcer;

var string WeaponOwner;

replication
{
	// Things the server should send to the client.
	reliable if( bNetOwner && Role==ROLE_Authority )
		WeaponOwner;
}

event float BotDesireability(Pawn Bot)
{

	return (0); 

}

auto state Pickup
{	
function Touch( actor Other )
	{
	if ( ValidTouch(Other) && Other.IsA('PlayerPawn') && WeaponOwner == PlayerPawn(Other).PlayerReplicationInfo.PlayerName) 
		{
		DeathMatchPlus(Level.Game).GiveWeapon(PlayerPawn(Other),"Monsterhunt2.MH2_Weapon_Lawgiver");
		PlayerPawn(Other).ReceiveLocalizedMessage( class'PickupMessagePlus', 0, None, None, Self.Class );
		PlayerPawn(Other).PlaySound(PickupSound);
		SetRespawn();
		}
	}
}

function ProcessTraceHit(Actor Other, Vector HitLocation, Vector HitNormal, Vector X, Vector Y, Vector Z)
{
	local UT_Shellcase s;
	local vector realLoc;
	local UT_SpriteBallExplosion U;

	realLoc = Owner.Location + CalcDrawOffset();
	s = Spawn(class'UT_ShellCase',, '', realLoc + 20 * X + FireOffset.Y * Y + Z);
	if ( s != None )
		s.Eject(((FRand()*0.3+0.4)*X + (FRand()*0.2+0.2)*Y + (FRand()*0.3+1.0) * Z)*160);              
	if (Other == Level) 
		{
		U = spawn(class'UT_SpriteBallExplosion',,, HitLocation+HitNormal, Rotator(HitNormal));
		U.DrawScale = 0.25;
		U.LightRadius = 3;
		}
	else if ((Other != self) && (Other != Owner) && (Other != None) ) 
		{
		if ( FRand() < 0.2 )
			X *= 5;
		Other.TakeDamage(HitDamage, Pawn(Owner), HitLocation, 3000.0*X, MyDamageType);

		U = spawn(class'UT_SpriteBallExplosion',,,HitLocation+HitNormal*9);
		U.DrawScale = 0.25;
		U.LightRadius = 3;
		}		
}


defaultproperties
{
hitdamage=50
PickupAmmoCount=200
PickupMessage="You got your Lawgiver back!"
ItemName="Lawgiver"
RespawnTime=0.00000
MultiSkins(0)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(1)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(2)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(3)=Texture'UnrealShare.Effect7.MyTex16'
MultiSkins(4)=Texture'UnrealShare.Effect7.MyTex16'
}
